<?php 
    include "../../conn.php";
    include "../../functions2.php";

    header('Content-Type: application/json; charset=utf-8');
    header('Strict-Transport-Security: max-age=31536000');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Access-Control-Allow-Origin: ' . $origin);
    header('vary: Origin');
    
    date_default_timezone_set("Asia/Kolkata");
    $shnunc = date("Y-m-d H:i:s");
    $res = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $shnunc,
    ];
    $shonubody = file_get_contents("php://input");
    $shonupost = json_decode($shonubody, true);
    if ($_SERVER['REQUEST_METHOD'] != 'GET') {
        if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['taskId']) && isset($shonupost['timestamp'])) {
            $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
            $taskId = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['taskId']));
            $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
            $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
            $shonustr = '{"language":'.$language.',"random":"'.$random.'","taskId":'.$taskId.'}';
            $shonusign = strtoupper(md5($shonustr));
            if($shonusign == $signature){
                $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
                $author = $bearer[1];				
                $is_jwt_valid = is_jwt_valid($author);
                $data_auth = json_decode($is_jwt_valid, 1);
                if($data_auth['status'] === 'Success') {
                    $sesquery = "SELECT akshinak
                      FROM shonu_subjects
                      WHERE akshinak = '$author'";
                    $sesresult=$conn->query($sesquery);
                    $sesnum = mysqli_num_rows($sesresult);
                    if($sesnum == 1){
                        $shonuid = $data_auth['payload']['id'];
                        
                        $taskRewards = [
                            1 => 55,
                            2 => 155,
                            3 => 555,
                            4 => 1555,
                            5 => 2955,
                            6 => 5655,
                            7 => 11555,
                            8 => 28555,
                            9 => 58555,
                            10 => 365555,
                            11 => 765555,
                            12 => 1655555,
                            13 => 3655555,
                        ];

                        if (isset($taskRewards[$taskId])) {
                            $reward = $taskRewards[$taskId];
                            $tathya = mysqli_query($conn, "INSERT INTO `noitativni_sonub` (`arthur`,`fleck`,`status`,`time`, `motta`) VALUES ('".$shonuid."','".$taskId."','1','".$shnunc."', '".$reward."')");
                            
                            $nabikarana = "UPDATE shonu_kaichila set motta = motta + $reward where balakedara='$shonuid'";
                            $conn->query($nabikarana);
                        }
                                
                        $res['code'] = 0;
                        $res['msg'] = 'Succeed';
                        $res['msgCode'] = 0;
                        http_response_code(200);
                        echo json_encode($res);			
                    }
                }
            }
            else{
                $res['code'] = 5;
                $res['msg'] = 'Wrong signature';
                $res['msgCode'] = 3;
                http_response_code(200);
                echo json_encode($res);
            }
        }
        else{
            $res['code'] = 7;
            $res['msg'] = 'Param is Invalid';
            $res['msgCode'] = 6;
            http_response_code(200);
            echo json_encode($res);
        }		
    } else {		
        http_response_code(405);
        echo json_encode($res);
    }	
?>